/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.launching.server;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.webserver.core.IServer;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PHPWebPageURLLaunchDialog
extends MessageDialog {
    private static Set previousURLs = new TreeSet();
    private ILaunchConfigurationWorkingCopy launchConfiguration;
    private Combo combo;
    private final IServer server;

    public PHPWebPageURLLaunchDialog(ILaunchConfigurationWorkingCopy launchConfiguration, IServer server, String title) {
        super(PHPDebugEPLPlugin.getActiveWorkbenchShell(), title, null, "", 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.launchConfiguration = launchConfiguration;
        this.server = server;
        this.message = "Note that no files will be published to the server.";
    }

    protected Control createCustomArea(Composite parent) {
        Object[] urls;
        Group group = new Group(parent, 0);
        group.setText("Launch URL");
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.combo = new Combo((Composite)group, 2052);
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        this.combo.setLayoutData((Object)data);
        Object[] objectArray = urls = previousURLs.toArray();
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.combo.add(element.toString());
            ++n2;
        }
        try {
            String selectedURL = this.launchConfiguration.getAttribute("ATTR_SERVER_BASE_URL", "");
            int comboIndex = this.combo.indexOf(selectedURL);
            if (comboIndex > -1) {
                this.combo.select(comboIndex);
            } else {
                this.combo.add(selectedURL, 0);
                this.combo.select(0);
            }
        }
        catch (CoreException e) {
            PHPDebugEPLPlugin.logError(e);
        }
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String url = this.combo.getText().trim();
            previousURLs.add(url);
            try {
                if (!url.equals(this.launchConfiguration.getAttribute("ATTR_SERVER_BASE_URL", ""))) {
                    this.launchConfiguration.setAttribute("ATTR_AUTO_GENERATED_URL", false);
                }
            }
            catch (CoreException e) {
                PHPDebugEPLPlugin.logError(e);
                this.launchConfiguration.setAttribute("ATTR_AUTO_GENERATED_URL", false);
            }
            this.launchConfiguration.setAttribute("ATTR_SERVER_BASE_URL", url);
        }
        super.buttonPressed(buttonId);
    }
}

